import 'package:flutter/material.dart';
import 'package:nb_utils/nb_utils.dart';

import '../../../components/view_all_label_component.dart';
import '../../../main.dart';
import '../../../utils/common_base.dart';
import '../model/branch_response.dart';

class BranchAboutComponent extends StatelessWidget {
  final String branchDescription;
  final List<WorkingHourList> workingList;

  BranchAboutComponent({required this.branchDescription, required this.workingList});

  @override
  Widget build(BuildContext context) {
    return SingleChildScrollView(
      physics: ClampingScrollPhysics(),
      padding: EdgeInsets.only(left: 16,right: 16, top: 4,bottom: 20),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          if (branchDescription.isNotEmpty)
            Column(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                ViewAllLabel(label: locale.description, isShowAll: false),
                ReadMoreText(branchDescription.validate(), style: secondaryTextStyle()),
                8.height,
              ],
            ),
          if (workingList.isNotEmpty)
            Column(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                ViewAllLabel(label: locale.workingHours, isShowAll: false),
                10.height,
                AnimatedListView(
                  itemCount: workingList.length,
                  shrinkWrap: true,
                  padding: EdgeInsets.zero,
                  listAnimationType: ListAnimationType.FadeIn,
                  physics: NeverScrollableScrollPhysics(),
                  itemBuilder: (p0, index) {
                    WorkingHourList data = workingList[index];
                    return Container(
                      padding: EdgeInsets.symmetric(vertical: 0),
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          SizedBox(
                            width: 100,
                            child: Marquee(
                              child: Text(
                                data.day!.capitalizeFirstLetter(),
                                style: secondaryTextStyle(),
                                textAlign: isRTL ? TextAlign.end : TextAlign.start,
                              ),
                              textDirection: isRTL ? TextDirection.rtl : TextDirection.ltr,
                            ),
                          ),
                          Spacer(),
                          Column(
                            mainAxisSize: MainAxisSize.min,
                            crossAxisAlignment: CrossAxisAlignment.end,
                            children: [
                              Text(
                                data.isHoliday == 0 ?
                                formatOnlyTime(context, startTime: data.startTime, endTime: data.endTime)
                                : "Close",
                                style: data.isHoliday == 0 ? primaryTextStyle(): primaryTextStyle(color: Colors.red)
                              ),
                              Column(
                                mainAxisSize: MainAxisSize.min,
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: data.branchBreaks!.map((breakItem) {
                                  return Text(
                                    "Break - ${formatOnlyTime(
                                      context,
                                      startTime: breakItem.startBreak,
                                      endTime: breakItem.endBreak,
                                    )}",
                                    style: primaryTextStyle(color: Colors.red),
                                  );
                                }).toList(),
                              ).visible(data.branchBreaks != null && data.branchBreaks!.isNotEmpty),
                            ],
                          ),
                        ],
                      ),
                    );
                  },
                ),
              ],
            ),
        ],
      ),
    );
  }
}