import 'package:frezka/main.dart';
import 'package:nb_utils/nb_utils.dart';
import 'package:onesignal_flutter/onesignal_flutter.dart';

import '../configs.dart';

Future<void> initOneSignal() async {
  ///Initialize
  OneSignal.initialize(ONESIGNAL_APP_ID);
  OneSignal.Notifications.requestPermission(true);
  OneSignal.User.pushSubscription.optIn();

  OneSignal.Debug.setAlertLevel(OSLogLevel.none);
  OneSignal.login(userStore.userEmail.validate());
  OneSignal.Debug.setLogLevel(OSLogLevel.debug);
  userStore.setPlayerId(OneSignal.User.pushSubscription.id.validate());
  OneSignal.Notifications.addForegroundWillDisplayListener((event) {
    log('');
    OneSignal.Notifications.displayNotification(event.notification.notificationId);
    return event.notification.display();
  });
  OneSignal.User.pushSubscription.addObserver((stateChanges) async {
    if (stateChanges.current.id.validate().isNotEmpty) {
      userStore.setPlayerId(stateChanges.current.id.validate());
    }
  });

  ///Save Player Id
  // saveOneSignalPlayerId();
}

/*Future<void> saveOneSignalPlayerId() async {
  if (appStore.isLoggedIn) {
    log('userStore.userId.toString()=== ${userStore.userId.toString()}');
    await OneSignal.login(userStore.userId.toString()).then((value) async {
      if (OneSignal.User.pushSubscription.id.validate().isNotEmpty) {
        userStore.setPlayerId(OneSignal.User.pushSubscription.id.validate());
        log('PLAYERID: ${appStore.playerId}');
      }
    }).catchError((e) {
      log('Error saving subscription id - $e');
    });
  }
}*/
